uniform sampler2D transmittance_texture;
uniform sampler3D scattering_texture;
#ifndef COMBINED_SCATTERING_TEXTURES
	uniform sampler3D single_mie_scattering_texture;
#endif
uniform sampler2D irradiance_texture;

uniform float mie_g;


float GetPhaseFunctions(vec3 view_ray, vec3 sun_direction, out float mie) 
{
	return GetPhases(ATMOSPHERE,view_ray,sun_direction,mie);
}

#ifdef RADIANCE_API_ENABLED

    vec3 GetSolarRadiance() 
	{
		return ATMOSPHERE.solar_irradiance / (PI * ATMOSPHERE.sun_angular_radius * ATMOSPHERE.sun_angular_radius);
    }
	
	vec3 GetTrasmittanceTexture(vec2 uv) 
	{
		return texture(transmittance_texture, uv).rgb; 
    }
	
	vec3 GetScatteringTexture(vec3 uv) 
	{
		return texture(scattering_texture, uv).rgb; 
    }
	
    vec3 GetSkyRadiance(vec3 camera, vec3 view_ray, float shadow_length, vec3 sun_direction, out vec3 transmittance) 
	{
		ATMOSPHERE.mie_phase_function_g=mie_g;
	#ifndef COMBINED_SCATTERING_TEXTURES	
		return GetSkyRadiance(ATMOSPHERE, transmittance_texture,
								scattering_texture, single_mie_scattering_texture,
								camera, view_ray, shadow_length, sun_direction, transmittance);
	#else
		return GetSkyRadianceCOMBINED(ATMOSPHERE, transmittance_texture,
								scattering_texture,	camera, view_ray, shadow_length, sun_direction, transmittance);
	#endif
    }
	
	vec3 GetSkyRadianceWithoutPhase(vec3 camera, vec3 view_ray, float shadow_length, vec3 sun_direction, out vec3 transmittance) 
	{
	#ifndef COMBINED_SCATTERING_TEXTURES	
		return GetSkyRadianceWithoutPhase(ATMOSPHERE, transmittance_texture,
							scattering_texture, single_mie_scattering_texture,
							camera, view_ray, shadow_length, sun_direction, transmittance);
	#else
		return GetSkyRadianceWithoutPhaseCOMBINED(ATMOSPHERE, transmittance_texture,
							scattering_texture,
							camera, view_ray, shadow_length, sun_direction, transmittance);
	#endif
    }
	
    vec3 GetSkyRadianceToPoint(vec3 camera, vec3 point, float shadow_length, vec3 sun_direction, out vec3 transmittance) 
	{
		ATMOSPHERE.mie_phase_function_g=mie_g;
	#ifndef COMBINED_SCATTERING_TEXTURES
		return GetSkyRadianceToPoint(ATMOSPHERE, transmittance_texture,
									scattering_texture, single_mie_scattering_texture,
									camera, point, shadow_length, sun_direction, transmittance);
	#else
		return GetSkyRadianceToPointCOMBINED(ATMOSPHERE, transmittance_texture,
									scattering_texture,
									camera, point, shadow_length, sun_direction, transmittance);
	#endif
    }
	
	vec3 GetSkyRadianceToAtmosphere(vec3 camera, vec3 point, float shadow_length, vec3 sun_direction, out vec3 transmittance) 
	{
		ATMOSPHERE.mie_phase_function_g=mie_g;
	#ifndef COMBINED_SCATTERING_TEXTURES
		return GetSkyRadianceToAtmosphere(ATMOSPHERE, transmittance_texture,
									scattering_texture, single_mie_scattering_texture,
									camera, point, shadow_length, sun_direction, transmittance);
	#else
		return GetSkyRadianceToAtmosphereCOMBINED(ATMOSPHERE, transmittance_texture,
									scattering_texture,
									camera, point, shadow_length, sun_direction, transmittance);
	#endif
    }
	
    vec3 GetSunAndSkyIrradiance(vec3 p, vec3 normal, vec3 sun_direction, out vec3 sky_irradiance) 
	{
		ATMOSPHERE.mie_phase_function_g=mie_g;
		return GetSunAndSkyIrradiance(ATMOSPHERE, transmittance_texture, irradiance_texture, p, normal, sun_direction, sky_irradiance);
    }
	
	vec3 GetSunIrradiance(vec3 p, vec3 sun_direction) 
	{
		ATMOSPHERE.mie_phase_function_g=mie_g;
		return GetSunIrradiance(ATMOSPHERE, transmittance_texture, p, sun_direction);
    }
	
	vec3 GetIndirectIrradiance(vec3 p, vec3 sun_direction) 
	{
		ATMOSPHERE.mie_phase_function_g=mie_g;
		return GetIndirectIrradiance(ATMOSPHERE, irradiance_texture, p, sun_direction);
	}
	
#endif

vec3 GetSolarLuminance() 
{
	return ATMOSPHERE.solar_irradiance / (PI * ATMOSPHERE.sun_angular_radius * ATMOSPHERE.sun_angular_radius) * SUN_SPECTRAL_RADIANCE_TO_LUMINANCE;
}

vec3 GetSkyLuminance(vec3 camera, vec3 view_ray, float shadow_length, vec3 sun_direction, out vec3 transmittance) 
{
	ATMOSPHERE.mie_phase_function_g=mie_g;
#ifndef COMBINED_SCATTERING_TEXTURES	
	return GetSkyRadiance(	ATMOSPHERE, transmittance_texture,
							scattering_texture, single_mie_scattering_texture,
							camera, view_ray, shadow_length, sun_direction, transmittance) * SKY_SPECTRAL_RADIANCE_TO_LUMINANCE;
#else
	return GetSkyRadianceCOMBINED(	ATMOSPHERE, transmittance_texture,
							scattering_texture,
							camera, view_ray, shadow_length, sun_direction, transmittance) * SKY_SPECTRAL_RADIANCE_TO_LUMINANCE;
#endif
}

vec3 GetSkyLuminanceWithoutPhase(vec3 camera, vec3 view_ray, float shadow_length, vec3 sun_direction, out vec3 transmittance) 
{
#ifndef COMBINED_SCATTERING_TEXTURES
	return GetSkyRadianceWithoutPhase(	ATMOSPHERE, transmittance_texture,
							scattering_texture, single_mie_scattering_texture,
							camera, view_ray, shadow_length, sun_direction, transmittance) * SKY_SPECTRAL_RADIANCE_TO_LUMINANCE;
#else
	return GetSkyRadianceWithoutPhaseCOMBINED(	ATMOSPHERE, transmittance_texture,
							scattering_texture,
							camera, view_ray, shadow_length, sun_direction, transmittance) * SKY_SPECTRAL_RADIANCE_TO_LUMINANCE;
#endif
}

vec3 GetSkyLuminanceToPoint(vec3 camera, vec3 point, float shadow_length, vec3 sun_direction, out vec3 transmittance) 
{
	ATMOSPHERE.mie_phase_function_g=mie_g;
#ifndef COMBINED_SCATTERING_TEXTURES
	return GetSkyRadianceToPoint(	ATMOSPHERE, transmittance_texture,
									scattering_texture, single_mie_scattering_texture,
									camera, point, shadow_length, sun_direction, transmittance) * SKY_SPECTRAL_RADIANCE_TO_LUMINANCE;
#else
	return GetSkyRadianceToPointCOMBINED(	ATMOSPHERE, transmittance_texture,
									scattering_texture,
									camera, point, shadow_length, sun_direction, transmittance) * SKY_SPECTRAL_RADIANCE_TO_LUMINANCE;
#endif
}

vec3 GetSkyLuminanceToAtmosphere(vec3 camera, vec3 point, float shadow_length, vec3 sun_direction, out vec3 transmittance) 
{
	ATMOSPHERE.mie_phase_function_g=mie_g;
#ifndef COMBINED_SCATTERING_TEXTURES
	return GetSkyRadianceToAtmosphere(	ATMOSPHERE, transmittance_texture,
										scattering_texture, single_mie_scattering_texture,
										camera, point, shadow_length, sun_direction, transmittance) * SKY_SPECTRAL_RADIANCE_TO_LUMINANCE;
#else
	return GetSkyRadianceToAtmosphereCOMBINED(	ATMOSPHERE, transmittance_texture,
										scattering_texture,
										camera, point, shadow_length, sun_direction, transmittance) * SKY_SPECTRAL_RADIANCE_TO_LUMINANCE;
#endif
}

vec3 GetSunAndSkyIlluminance(vec3 p, vec3 normal, vec3 sun_direction, out vec3 sky_irradiance) 
{
	ATMOSPHERE.mie_phase_function_g=mie_g;
	vec3 sun_irradiance = GetSunAndSkyIrradiance(	ATMOSPHERE, transmittance_texture, 
																irradiance_texture, p, normal,
																sun_direction, sky_irradiance);
	sky_irradiance *= SKY_SPECTRAL_RADIANCE_TO_LUMINANCE;
	return sun_irradiance * SUN_SPECTRAL_RADIANCE_TO_LUMINANCE;
}

vec3 GetSunIlluminance(vec3 p, vec3 sun_direction) 
{
	ATMOSPHERE.mie_phase_function_g=mie_g;
	return GetSunIrradiance(ATMOSPHERE, transmittance_texture, p, sun_direction)*SKY_SPECTRAL_RADIANCE_TO_LUMINANCE;
}

vec3 GetIndirectLuminance(vec3 p, vec3 sun_direction) 
{
	ATMOSPHERE.mie_phase_function_g=mie_g;
	return GetIndirectIrradiance(ATMOSPHERE, irradiance_texture, p, sun_direction)*SKY_SPECTRAL_RADIANCE_TO_LUMINANCE;
}
	
	